#include <stdio.h>
#include <stdlib.h>
#include <odyssey.h>

#define N	2000
#define PROCS	5

double A[N][N], B[N][N], C[N][N], D[N];

void matMult(int n);

main()
{
    int i;

    for (i = 0; i < N; i++ ) {
	D[i] = -40;
    }

    parloop (i, 0, PROCS) {
	int j;
	int begin, end;
	
	begin = i * (N / PROCS);
	end   = begin + (N / PROCS);

	printf("This is thread #%d ==> %d to %d\n", i, begin, end);

	for (j = begin; j < end; j++) {
	    matMult(N);
	    D[j] = j;
	}
    }

    printf("\nThreads done. Checking the results... "); fflush(stdout);
    for (i = 0; i < N; i++) {
	if (D[i] != i) {
	    printf("failed at position %d\n", i);
	    return 1;
	}
    }
    printf("Ok\n");
}


void matMult(int n)
{
    int i, j, k;

    for (i = 0; i < n; i++) {
	for (j = 0; j < n; j++) {
	    C[i][j] = 0;
	    A[i][j] = drand48() * n;
	    B[i][j] = drand48() * n;
	}
    }

    for (i = 0; i < n; i++) {
	for (j = 0; j < n; j++) {
	    for (k = 0; k < n; k++) {
		C[i][j] += A[i][k] * B[k][j];
	    }
	}
    }
}
