#include <odyssey.h>

#define N 	10
#define MAX	20

typedef struct {
    int lock;
    int value;
} semaphore;

void down(semaphore *s);
void up(semaphore *s);

int Produce(void);

main()
{
    int A[N];
    int prod[MAX + 1], cons[MAX + 1];
    int i;
    semaphore full, empty;
    int mutex;

    full.lock  = 1; full.value  = 0;
    empty.lock = 2; empty.value = N;
    mutex      = 3;

    cobegin
	/* Producer thread */
	T 0: {
	    int end = 0;
	    int item;
	    int prodix = 0;
	    int prodix1 = 0;

	    while (!end) {
		down(&empty);
		suif_lock(mutex);

		item = Produce();
		A[prodix] = item;
		prodix = (prodix + 1) % N;

		prod[prodix1++] = item;

		printf("Producer: produced %d\n", item);
		if (item < 0) {
		    printf("Producer: tired of producing, bye\n");
		    end = 1;
		}

		suif_unlock(mutex);
		up(&full);
	    }
	    break;
	}

	/* Consumer thread */
	T 1: {
	    int end = 0;
	    int item;
	    int consix = 0;
	    int consix1 = 0;

	    while (!end) {
		down(&full);
		suif_lock(mutex);

		item = A[consix];
		consix = (consix + 1) % N;

		cons[consix1++] = item;

		printf("Consumer: consumed %d\n", item);
		if (item < 0) {
		    printf("Consumer: consumed last piece, bye\n");
		    end = 1;
		}

		suif_unlock(mutex);
		up(&empty);
	    }
	    break;
	}
    coend

    printf("Elements produced: ");
    for (i = 0; i < MAX; i++) {
	printf("%d ", prod[i]);
    }
    printf("\n");

    printf("Elements consumed: ");
    for (i = 0; i < MAX; i++) {
	printf("%d ", cons[i]);
    }
    printf("\n");
}


int Produce(void)
{
    static int numprod = 0;
    int item;

    numprod++;
    if (numprod > MAX) {
	item = -1;
    } else {
	item = (random() % N);
    }

    return item;
}


void down(semaphore *s)
{
    suif_lock(s->lock);
    while (s->value <= 0) ;
    s->value = s->value - 1;
    suif_unlock(s->lock);
}


void up(semaphore *s)
{
    s->value = s->value + 1;
}
