#----------------------------------------------------------------------------
# Configuration section. Edit the following line to specify the directory
# where Odyssey was installed.
#----------------------------------------------------------------------------

setenv ODYSSEY	`pwd`


#----------------------------------------------------------------------------
# End of user configurable section. Do not edit below this line.
#----------------------------------------------------------------------------
setenv SUIFHOME			${ODYSSEY}

switch (`uname -s`)
case "IRIX*":
	setenv MACHINE		mips-sgi-irix5.3
	setenv COMPILER_NAME	sgi_c++
	setenv SUIFPATH		${SUIFHOME}/${MACHINE}/bin:/usr/gnu/lib/gcc-lib/mips-sgi-irix5.3/2.7.2
	breaksw

case "Linux":
	setenv MACHINE		i386-linux
	setenv COMPILER_NAME	gcc
	setenv SUIFPATH		${SUIFHOME}/${MACHINE}/bin:/lib
	breaksw

default:
	echo "Unsupported system `uname -s`"
	exit 1
	breaksw
endsw

setenv PL_NUM_THREADS	8
setenv PL_PROC_START	0
setenv PL_MAXPROC	8
setenv PATH 		${ODYSSEY}/${MACHINE}/bin:${PATH}

alias suifthreads	'setenv PL_NUM_THREADS'

echo ""
echo "Odyssey is configured as follows:"
echo ""
echo "ODYSSEY       = $ODYSSEY"
echo "MACHINE       = $MACHINE"
echo "COMPILER_NAME = $COMPILER_NAME"
echo ""
