/**
$Id: ccfg.h,v 1.8 1999/03/13 19:12:46 diego Exp $
*/
/*  Top-level Control Flow Graph Include File */

/*  Copyright (c) 1994 Stanford University

    All rights reserved.

    Copyright (c) 1995, 1996, 1997 The President and Fellows of Harvard 
    University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file.
*/
#ifndef CCFG_H
#define CCFG_H

#include <suif_copyright.h>

#include <set>
#include <list>
#include <map>

#include <par.h>

using namespace std;


/* Annotations for data references and synchronization instructions */
extern char *k_refs;		/// References made in a statement. Also,
				///   list of references for a variable.
extern char *k_defs;		/// Definitions made in a statement. Also,
				///   list of definitions for a variable.
extern char *k_uses;		/// Uses made in a statement. Also, list of
				///   uses for a variable.
extern char *k_phi_terms;	/// PHI terms in a statement/variable.
extern char *k_pi_terms;	/// PI terms in a statement/variable.
extern char *k_mutex_sync;	/// This statement/variable is lock/unlock.
extern char *k_lock_refs;	/// Set of lock references to the variable.
extern char *k_unlock_refs;	/// Set of unlock references to the variable.
extern char *k_entry_set;	/// Bitset of nodes that lock a variable.
extern char *k_exit_set;	/// Bitset of nodes that unlock a variable.
extern char *k_sync_var;	/// Variable is a synchronization variable.
extern char *k_conflicts;	/// List of conflicting references made in
				///   the statement.

/* Data flow annotations used */
extern char *k_reaching_defs;	/// Definitions reaching the statement.
extern char *k_reached_uses;	/// Uses reached by the statement.
extern char *k_currdef;		/// Current definition for a variable.
extern char *k_mutex_struct;	/// Mutex structure for a synch variable.

/*  annotations to attach CCFGs to SUIF objects */
extern char *k_ccfg;		/// CCFG associated with this proc symbol.
extern char *k_ccfg_node;	/// CCFG node holding this instruction.
extern char *k_ccfg_cobegin;	/// cobegin node holding this instruction.
extern char *k_ccfg_coend;	/// coend node holding this instruction.
extern char *k_ccfg_begin;	/// begin node holding this instruction.
extern char *k_ccfg_end;	/// end node holding this instruction.
extern char *k_ccfg_test;	/// test node holding this instruction.
extern char *k_ccfg_toplab;	/// label node holding this instruction.
extern char *k_proc_entry;	/// This instruction is a procedure entry.


/*
 * Use a macro to include files so that they can be treated differently
 * when compiling the library than when compiling an application.
 */
#ifdef CSSAMELIB
#	include "wrappers-cssame.h"
#	include "graph.h"
#	include "node.h"
#	include "varref.h"
#       include "mutex-analysis.h"
#	include "util.h"
#else
#	include <wrappers-cssame.h>
#	include <graph.h>
#	include <node.h>
#	include <varref.h>
#       include <mutex-analysis.h>
#	include <util.h>
#endif

#endif /* CCFG_H */
