/**
$Id: cssame.h,v 2.15 1999/03/05 14:50:35 diego Exp $
*/
#ifndef __CSSAME_H
#define __CSSAME_H

#ifdef CSSAMELIB
#    include "ccfg.h"
#else
#    include <ccfg.h>
#endif

#include <d_lib.h>

class ccfg;

/**
Class cssame represents the CSSAME form for a concurrent control flow graph.
*/
class cssame { D_CLASS(cssame)
public:
    cssame(p_ccfg graph) : _graph(graph) { buildCSSAME(); }
    ~cssame();

    p_ccfg graph() const { return _graph; }
    set_var_sym& mutexVars() { return _mutexVars; }

    void computeReachingDefs();
    void print(ostream& f = cout) const;

protected:
    p_ccfg _graph;
    set_var_sym _mutexVars;
    set_var_sym _symbols;

    /* Internal methods used in the creation of concurrent FUD chains */
    void buildCSSAME();
    void computeOrdering();
    void placePhiFunctions();
    void placeFUDChains();
    void searchFUDChains(p_ccfg_node n);
    void placePiFunctions();
    void rewritePiFunctions();
    void removeRedundantPis();
    void removeRedundantPhis();
    void buildSymbolList();

    /* Add conflict and synchronization edges to the graph. Since these edges
     * may cross graph boundaries, this method should be called after the
     * graphs for all the procedures have been built.
     */
    void addConfSyncEdges();

    /* Helper method to compute reaching definitions */
    void followChain(p_vardef d, p_varuse u);

    /* Helper method for computing the CSSAME form */
    void addGhostDefinitions();

    /* Methods used to find mutex structures in the program */
    void findMutexBodies();
    set_ccfg_node *find_entry_set(const p_var_sym& var) const;
    set_ccfg_node *find_exit_set(const p_var_sym& var) const;
    mutex_struct *find_mutex_struct(p_var_sym var, set_ccfg_node *pn, 
	    set_ccfg_node *px);
    void cleanup_mutex_struct(p_var_sym var, mutex_struct *s);
};

ostream& operator<<(ostream& f, const cssame& c);

#endif	// __CSSAME_H
