/**
$Id: graph-dfa.cc,v 2.29 1999/03/05 14:50:36 diego Exp $
*/
#include <set>
#include <list>

#include <suif_copyright.h>

#define _MODULE_ "CSSAME"

#include <values.h>
#include <ctype.h>

#include <suif.h>
#include <useful.h>
#include <cg.h>
#include <par.h>
#include <odc-util.h>
#include <d_lib.h>

#include "ccfg.h"

using namespace std;

/*---------------------------------------------------------------------------
			 Protected and private methods
---------------------------------------------------------------------------*/
/**
Collect memory references for the procedure. Notice that this method simply
makes a local copy of the collection of references from the annotation
k_refs for the procedure.
*/
void
ccfg::findRefs()
{
    D_SELFTEST_HEADER(220, "ccfg::findRefs");

    /* Make sure that we only collect references once */
    if (_refs_collected) {
	return;
    }

    if (!_graph_built) {
	assert_msg(false, ("Method ccfg::findRefs() cannot operate on an "
		    "incomplete graph.\n"));
    }

    set_varref *refs = ::get_varrefs(this->tproc().ptr(), false);
    if (!refs) {
	warning_line(this->tproc().ptr(), "References have not been computed "
		"for function %s\n", this->tproc()->proc()->name());
	return;
    }

    _refs = *refs;
    _uses.erase(_uses.begin(), _uses.end());
    _defs.erase(_defs.begin(), _defs.end());

    D_SELFTEST(220) {
	cout << "References found in procedure '" << 
	    this->tproc()->proc()->name() << "':\n";
	copy(_refs.begin(), _refs.end(),ostream_iterator<p_varref>(cout, "\n"));
    }

    /* Separate variable definitions and uses into their own collections.
     * Not really needed, it takes more memory but it simplifies some
     * traversals.
     */
    for (set_varref::iterator i = _refs.begin(); i != _refs.end(); i++) {
	p_varref ref = *i;
	if (ref->isD()) {
	    _defs.insert(ref);
	} else if (ref->isU()) {
	    _uses.insert(ref);
	}
    }

    /* Find all the references made by each flow graph node */
    D_SELFTEST(220) { cout << "\nLooking for references in nodes\n"; }
    for (unsigned i = 0; i < this->num_nodes(); i++) {
	this->node(i)->findRefs();
	D_SELFTEST(161) {
	    cout << "References in node #" << i << endl;
	    copy(this->node(i)->refs().begin(), this->node(i)->refs().end(),
		    ostream_iterator<p_varref>(cout, "\n"));
	    cout << endl << endl;
	}
    }

    _refs_collected = true;

    D_SELFTEST_FOOTER(220);
}
