/**
$Id: init.cc,v 2.10 1999/03/13 19:12:49 diego Exp $
*/

#define _MODULE_ "CSSAME"

#include <suif.h>

/** Reaching definitions annotation for statements */
char *k_reaching_defs;
char *k_reached_uses;
char *k_currdef;
char *k_mutex_struct;

/*  annotation names */
char *k_ccfg;
char *k_ccfg_node;
char *k_ccfg_cobegin;
char *k_ccfg_coend;
char *k_ccfg_begin;
char *k_ccfg_end;
char *k_ccfg_test;
char *k_ccfg_toplab;
char *k_proc_entry;

/* Annotations for data references and synchronization instructions */
char *k_refs;
char *k_defs;
char *k_uses;
char *k_phi_terms;
char *k_pi_terms;
char *k_mutex_sync;
char *k_lock_refs;
char *k_unlock_refs;
char *k_entry_set;
char *k_exit_set;
char *k_sync_var;
char *k_conflicts;


/**
Initialization and finalization functions for the CSSAME library.
*/
void
init_cssame (int & /* argc */, char * /* argv */ [])
{
    /* control flow graph annotations are unregistered */
    k_ccfg = lexicon->enter("ccfg")->sp;
    k_ccfg_node = lexicon->enter("ccfg_node")->sp;
    k_ccfg_cobegin = lexicon->enter("ccfg_cobegin")->sp;
    k_ccfg_coend = lexicon->enter("ccfg_coend")->sp;
    k_ccfg_begin = lexicon->enter("ccfg_begin")->sp;
    k_ccfg_end = lexicon->enter("ccfg_end")->sp;
    k_ccfg_test = lexicon->enter("ccfg_test")->sp;
    k_ccfg_toplab = lexicon->enter("ccfg_toplab")->sp;
    k_proc_entry = lexicon->enter("proc_entry")->sp;

    /* Data and synchronization annotations */
    k_refs = lexicon->enter("refs")->sp;
    k_defs = lexicon->enter("defs")->sp;
    k_uses = lexicon->enter("uses")->sp;
    k_phi_terms = lexicon->enter("phi_terms")->sp;
    k_pi_terms = lexicon->enter("pi_terms")->sp;
    k_mutex_sync = lexicon->enter("mutex_sync")->sp;
    k_lock_refs = lexicon->enter("lock_refs")->sp;
    k_unlock_refs = lexicon->enter("unlock_refs")->sp;
    k_entry_set = lexicon->enter("entry_set")->sp;
    k_exit_set = lexicon->enter("exit_set")->sp;
    k_sync_var = lexicon->enter("sync_var")->sp;
    k_conflicts = lexicon->enter("conflicts")->sp;

    k_reaching_defs = lexicon->enter("reaching_defs")->sp;
    k_reached_uses = lexicon->enter("reached_uses")->sp;
    k_currdef = lexicon->enter("currdef")->sp;
    k_mutex_struct = lexicon->enter("mutex_struct")->sp;
}


void
exit_cssame ()
{
}
