/**
$Id: mutex-analysis.h,v 2.14 1999/03/05 14:50:39 diego Exp $
*/
#ifndef __MUTEX_ANALYSIS_H
#define __MUTEX_ANALYSIS_H

#include <list>

#include <iostream.h>

#include <d_lib.h>

using namespace std;

/**
Strict intervals or mutex bodies.
*/
class mutex_body { D_CLASS(mutex_body)
public:
    mutex_body(p_var_sym var, p_ccfg_block n, p_ccfg_block x, mutex_struct *s);
    mutex_body() {}
    mutex_body(const mutex_body& o);
    ~mutex_body();

    mutex_body& operator=(const mutex_body& o);

    /** Access methods. */
    p_var_sym var() const { return _var; }
    ccfg *parent() const { return _entry->parent(); }
    p_ccfg_block& entry() { return _entry; }
    p_ccfg_block& exit() { return _exit; }
    p_tree_instr& entry_ti() { return _entry_ti; }
    p_tree_instr& exit_ti() { return _exit_ti; }
    set_ccfg_node& body() { return _body; }
    mutex_struct *mxstruct() const { return _mxstruct; }

    const set_vardef& exitRDefs() const { return _exitRDefs; }
    const set_varuse& upwardExposedUses() const { return _upwardExposedUses; }

    /** Data flow information methods. */
    void computeExitRDefs();
    void computeUpwardExposedUses();
    void rewritePiFunctions();

    /** Display methods. */
    void print(ostream& f=cout) const;
    void print_brief(ostream& f=cout) const;
    void printBody(ostream& f=cout) const;

    bool operator==(const mutex_body& o) {
	return (_entry == o._entry && _exit == o._exit);
    }

    bool operator<(const mutex_body& o) const { return _entry < o._entry; }

protected:
    p_var_sym _var;
    p_ccfg_block _entry;
    p_ccfg_block _exit;
    set_ccfg_node _body;
    p_tree_instr _entry_ti;
    p_tree_instr _exit_ti;
    set_vardef _exitRDefs;
    set_varuse _upwardExposedUses;
    mutex_struct *_mxstruct;
};

ostream& operator<<(ostream& f, const mutex_body& interval);

#endif // __MUTEX_ANALYSIS_H
