/**
$Id: node-dfa.cc,v 2.22 1999/03/05 14:50:39 diego Exp $
*/
#include <suif_copyright.h>

#define _MODULE_ "CSSAME"

#include <set>
#include <list>

#include <string.h>

#include <suif.h>
#include <par.h>
#include <odc-util.h>
#include <d_lib.h>

#include "ccfg.h"

using namespace std;

/**
Looks for all variable references in this instruction node.
*/
void
ccfg_instr::findRefs()
{
    D_SELFTEST_HEADER(160, "ccfg_instr::findRefs");

    D_SELFTEST(160) {
	cout << "Looking for references in\n";
	this->ti->instr()->print();
	cout << "\n";
    }

    _refs.erase(_refs.begin(), _refs.end());
    _uses.erase(_uses.begin(), _uses.end());
    _defs.erase(_defs.begin(), _defs.end());

    set_varref *r = ::get_varrefs(ti.ptr());
    if (r) {
	for (set_varref::iterator i = r->begin(); i != r->end(); i++) {
	    p_varref ref = *i;
	    ref->set_node(this);
	    _refs.insert(ref);
	    if (ref->isD()) {
		_defs.insert(ref);
	    } else if (ref->isU()) {
		_uses.insert(ref);
	    }
	}
    }

    D_SELFTEST(160) {
	cout << "References found in node " << this->number() << endl;
	copy(_refs.begin(), _refs.end(), 
	     ostream_iterator<p_varref>(cout, "\n")
	    );
    }

    D_SELFTEST_FOOTER(160);
}



/**
Looks for all variable references in this basic block node.
*/
void
ccfg_block::findRefs()
{
    D_SELFTEST_HEADER(160, "ccfg_block::findRefs");

    _refs.erase(_refs.begin(), _refs.end());
    _defs.erase(_defs.begin(), _defs.end());
    _uses.erase(_uses.begin(), _uses.end());

    ccfg_node_instr_iter iter(this);
    while (!iter.is_empty()) {
	tree_instr *ti = iter.step();

	D_SELFTEST(160) {
	    cout << "Looking for references in\n";
	    ti->print();
	    cout << "\n";
	}

	set_varref *r = ::get_varrefs(ti);
	if (!r) { continue; }

	for (set_varref::iterator i = r->begin(); i != r->end(); i++) {
	    p_varref ref = *i;
	    bool add = true;

	    tree_node *parent = ti->parent()->parent();
	    if (parent && parent->is_for()) {
		/* Special case. If this instruction is inside the
		 * step_list of a tree_for header, we have to ignore all
		 * references to the index variable because they will be
		 * associated to the appropriate nodes by
		 * ccfg_test::findRefs().
		 */
		tree_for *tf = (tree_for *)parent;
		tree_node_list *li = ti->parent();
		if (li == tf->step_list() && ref->var() == tf->index()) {
		    D_SELFTEST(160) {
			cout << "Instruction is a reference to the index"
			    << " variable inside a for header. Skipping.\n";
		    }
		    add = false;
		}
	    }

	    if (add) {
		ref->set_node(this);
		_refs.insert(ref);
		if (ref->isD()) {
		    _defs.insert(ref);
		} else if (ref->isU()) {
		    _uses.insert(ref);
		}
	    }
	}
    }

    D_SELFTEST(160) {
	cout << "References found in node " << this->number() << endl;
	copy(_refs.begin(), _refs.end(), 
	     ostream_iterator<p_varref>(cout, "\n")
	    );
    }

    D_SELFTEST_FOOTER(160);
}


/**
Looks for references in the header nodes of a tree_for
*/
void
ccfg_test::findRefs()
{
    D_SELFTEST_HEADER(160, "ccfg_test::findRefs");

    _refs.erase(_refs.begin(), _refs.end());
    _defs.erase(_defs.begin(), _defs.end());
    _uses.erase(_uses.begin(), _uses.end());

    /* The test node makes three references:
     *
     * 1- A use to test the index variable against the upper bound.
     * 2- Another use to read the old value of the index variable.
     * 3- A definition to assign the new value of the index variable.
     */
    tree_node_list_iter iter(tf->step_list());
    while (!iter.is_empty()) {
	tree_instr *ti = (tree_instr *)iter.step();
	set_varref *ti_refs = ::get_varrefs(ti);
	if (!ti_refs) { continue; }

	set_varref::iterator refs_iter = ti_refs->begin();
	for (; refs_iter != ti_refs->end(); refs_iter++) {
	    p_varref ref = *refs_iter;
	    if (ref->var() == tf->index()) {
		ref->set_node(this);
		_refs.insert(ref);
		if (ref->isD()) {
		    _defs.insert(ref);
		} else if (ref->isU()) {
		    _uses.insert(ref);
		}
	    }
	}
    }

    D_SELFTEST(160) {
	cout << "References found in node " << this->number() << endl;
	copy(_refs.begin(), _refs.end(), 
	     ostream_iterator<p_varref>(cout, "\n")
	    );
    }

    D_SELFTEST_FOOTER(160);
}

/**
Returns the PI term for the given variable. If the node does not have a
PI term for the variable, it returns NULL.
*/
p_phiterm
ccfg_node::hasPi(p_var_sym var)
{
    set_phiterm::iterator iter;
    for (iter = _phiterms.begin(); iter != _phiterms.end(); iter++) {
	p_phiterm pi = *iter;
	if (pi->var() == var && !pi->removed()) {
	    return pi;
	}
    }

    return NULL;
}
