/**
$Id: util.h,v 2.14 1999/03/13 19:12:51 diego Exp $

Control Flow Graph Utilities

Copyright (c) 1994 Stanford University

All rights reserved.

Copyright (c) 1995, 1996, 1997 The President and Fellows of Harvard
University

All rights reserved.

This software is provided under the terms described in the
"suif_copyright.h" include file.
*/
#ifndef CCFG_UTIL_H
#define CCFG_UTIL_H

#include <suif_copyright.h>

#include <set>

#include <cg.h>

using namespace std;

/*  functions to find CCFG nodes associated with various objects */
p_ccfg_label label_ccfg_node(p_label_sym l);
p_ccfg_begin ccfg_begin_node(p_tree_node n);
p_ccfg_end ccfg_end_node(p_tree_node n);
p_ccfg_test ccfg_test_node(p_tree_for n);
p_ccfg_label ccfg_toplab(p_tree_for n);

/* Various neat functions added */
extern void generate_vcg(FILE *f, ccfg *ccfg);    /* Dump vcg format file   */

/* Iterator over instructions in a ccfg_block */
class ccfg_node_instr_iter {
  private:
    tree_node_list_e *first;
    tree_node_list_e *last;
    tree_node_list_e *sentinel;
    tree_node_list_e *cur;
    tree_node_list_e *nxt;
    bool rev; 

  public:
    ccfg_node_instr_iter(ccfg_node *node, bool reverse=false, bool
	    exec=false);

    void reset();
    tree_instr *step();
    tree_instr *peek();

    bool is_empty();
};

/* Helper functions */
extern bool occurs(p_ccfg_node cn, ccfg_node_list *cnl); 
extern p_tree_instr first_ti(tree_node_list *tnl);
extern p_tree_instr last_ti(tree_node_list *tnl);

extern bool is_nop(p_tree_node tn);
extern bool is_cti(p_tree_node tn);
extern bool is_ubr(p_tree_node tn);
extern bool is_cbr(p_tree_node tn);
extern bool is_mbr(p_tree_node tn);
extern bool is_ret(p_tree_node tn);
extern bool is_label(p_tree_node tn);
extern bool is_fall_through(p_tree_node tn);
extern bool is_call(p_tree_node tn);
extern bool is_exec(p_tree_node tn);
extern p_label_sym get_label(p_tree_instr ti);
extern p_sym_node get_target(p_tree_instr ti);
extern bool is_allowedInBlock(p_tree_node tn);
extern bool is_startOfBlock(p_tree_node tn);
extern bool is_endOfBlock(p_tree_node tn);

/* Interface to the annotations */
p_ccfg get_ccfg(p_tree_block block);
set_varref *get_varrefs(suif_object *obj, bool create_if_null = true);
set_vardef *get_vardefs(suif_object *obj);
set_varuse *get_varuses(suif_object *obj);
set_phiterm *get_phiterms(suif_object *obj);
set_phiterm *get_piterms(suif_object *obj);
list_conflict *get_conflicts(suif_object *obj, bool create_if_null = true);
vector_vardef *get_reaching_defs(suif_object *obj);
vector_varuse *get_reached_uses(suif_object *obj);
p_vardef get_currdef(p_var_sym var);
mutex_struct *get_mutex_struct(p_var_sym var);
set_ccfg_node *get_entry_set(p_var_sym var);
set_ccfg_node *get_exit_set(p_var_sym var);
bool is_mutex_sync(p_var_sym var);
set_lockref *get_lockrefs(p_var_sym var);
set_unlockref *get_unlockrefs(p_var_sym var);
p_ccfg_node get_node(p_tree_node n);

void set_ccfg(p_tree_block block, p_ccfg graph);
void set_varrefs(suif_object *obj, set_varref *refs);
void set_reaching_defs(suif_object *obj, vector_vardef *rdefs);
void set_reached_uses(suif_object *obj, vector_varuse *ruses);
void set_mutex_struct(suif_object *obj, mutex_struct *mxstruct);
void set_entry_set(suif_object *obj, set_ccfg_node *npart);
void set_exit_set(suif_object *obj, set_ccfg_node *xpart);
void set_conflicts(suif_object *obj, list_conflict *conf);
void set_begin_node(suif_object *obj, p_ccfg_begin node);
void set_cobegin_node(suif_object *obj, p_ccfg_cobegin node);
void set_end_node(suif_object *obj, p_ccfg_end node);
void set_coend_node(suif_object *obj, p_ccfg_coend node);
void set_node(suif_object *obj, p_ccfg_node node);
void set_test_node(suif_object *obj, p_ccfg_test node);
void set_currdef(p_var_sym var, p_vardef def);

/* In file findrefs.cc */
set_varref *find_memory_refs(tree_proc *tp);

/* In file findconflicts.cc */
list_conflict *find_memory_conflicts(tree_proc *tp);

#endif /* CCFG_UTIL_H */
