/**
$Id: wrappers-cssame.h,v 2.8 1999/03/13 19:12:52 diego Exp $

Wrapper and smart pointer classes for the CSSAME library.
*/
#ifndef	__CSSAME_WRAPPERS_H
#define __CSSAME_WRAPPERS_H

#include <wrappers.h>
#include <par.h>

/**
Forward declarations for the classes declared in this module.
*/
class ccfg_node;
class ccfg_marker;
class ccfg_begin;
class ccfg_cobegin;
class ccfg_end;
class ccfg_coend;
class ccfg_label;
class ccfg_instr;
class ccfg_block;
class ccfg_test;

class varref;
class vardef;
class phiterm;
class varuse;
class syncref;
class undir_syncref;
class mutex_syncref;
class lockref;
class unlockref;
class conflict;
class mutex_body;
class cssame;
class ccfg;

typedef pWrapper<mutex_body *> p_mutex_body;
typedef pWrapper<cssame *> p_cssame;
typedef pWrapper<ccfg *> p_ccfg;

/*---------------------------------------------------------------------------
			Wrappers for the flowgraph nodes
---------------------------------------------------------------------------*/
class p_ccfg_node : public pWrapper<ccfg_node *> {
public:
    p_ccfg_node(ccfg_node *p = 0) : pWrapper<ccfg_node *>(p) {}
    p_ccfg_node(const p_ccfg_node& o) : pWrapper<ccfg_node *>(o) {}
};

class p_ccfg_marker : public p_ccfg_node {
public:
    p_ccfg_marker(ccfg_marker *p = 0) : p_ccfg_node((ccfg_node *)p) {}
    p_ccfg_marker(const p_ccfg_marker& o) : p_ccfg_node(o) {}
    p_ccfg_marker(const p_ccfg_node& o) : p_ccfg_node(o) {}
    ccfg_marker *operator->() const { return (ccfg_marker *)_p; }
//     ccfg_marker *operator()() const { return (ccfg_marker *)_p; }
};

class p_ccfg_begin : public p_ccfg_marker {
public:
    p_ccfg_begin(ccfg_begin *p = 0) : p_ccfg_marker((ccfg_marker *)p) {}
    p_ccfg_begin(const p_ccfg_begin& o) : p_ccfg_marker(o) {}
    p_ccfg_begin(const p_ccfg_marker& o) : p_ccfg_marker(o) {}
    p_ccfg_begin(const p_ccfg_node& o) : p_ccfg_marker(o) {}
    ccfg_begin *operator->() const { return (ccfg_begin *)_p; }
//     ccfg_begin *operator()() const { return (ccfg_begin *)_p; }
};

class p_ccfg_cobegin : public p_ccfg_begin {
public:
    p_ccfg_cobegin(ccfg_cobegin *p = 0) : p_ccfg_begin((ccfg_begin *)p) {}
    p_ccfg_cobegin(const p_ccfg_cobegin& o) : p_ccfg_begin(o) {}
    p_ccfg_cobegin(const p_ccfg_begin& o) : p_ccfg_begin(o) {}
    p_ccfg_cobegin(const p_ccfg_marker& o) : p_ccfg_begin(o) {}
    p_ccfg_cobegin(const p_ccfg_node& o) : p_ccfg_begin(o) {}
    ccfg_cobegin *operator->() const { return (ccfg_cobegin *)_p; }
//     ccfg_cobegin *operator()() const { return (ccfg_cobegin *)_p; }
};

class p_ccfg_end : public p_ccfg_marker {
public:
    p_ccfg_end(ccfg_end *p = 0) : p_ccfg_marker((ccfg_marker *)p) {}
    p_ccfg_end(const p_ccfg_end& o) : p_ccfg_marker(o) {}
    p_ccfg_end(const p_ccfg_marker& o) : p_ccfg_marker(o) {}
    p_ccfg_end(const p_ccfg_node& o) : p_ccfg_marker(o) {}
    ccfg_end *operator->() const { return (ccfg_end *)_p; }
//     ccfg_end *operator()() const { return (ccfg_end *)_p; }
};

class p_ccfg_coend : public p_ccfg_end {
public:
    p_ccfg_coend(ccfg_coend *p = 0) : p_ccfg_end((ccfg_end *)p) {}
    p_ccfg_coend(const p_ccfg_coend& o) : p_ccfg_end(o) {}
    p_ccfg_coend(const p_ccfg_end& o) : p_ccfg_end(o) {}
    p_ccfg_coend(const p_ccfg_marker& o) : p_ccfg_end(o) {}
    p_ccfg_coend(const p_ccfg_node& o) : p_ccfg_end(o) {}
    ccfg_coend *operator->() const { return (ccfg_coend *)_p; }
//     ccfg_coend *operator()() const { return (ccfg_coend *)_p; }
};

class p_ccfg_label : public p_ccfg_marker {
public:
    p_ccfg_label(ccfg_label *p = 0) : p_ccfg_marker((ccfg_marker *)p) {}
    p_ccfg_label(const p_ccfg_label& o) : p_ccfg_marker(o) {}
    p_ccfg_label(const p_ccfg_marker& o) : p_ccfg_marker(o) {}
    p_ccfg_label(const p_ccfg_node& o) : p_ccfg_marker(o) {}
    ccfg_label *operator->() const { return (ccfg_label *)_p; }
//     ccfg_label *operator()() const { return (ccfg_label *)_p; }
};

class p_ccfg_instr : public p_ccfg_node {
public:
    p_ccfg_instr(ccfg_instr *p = 0) : p_ccfg_node((ccfg_node *)p) {}
    p_ccfg_instr(const p_ccfg_instr& o) : p_ccfg_node(o) {}
    p_ccfg_instr(const p_ccfg_node& o) : p_ccfg_node(o) {}
    ccfg_instr *operator->() const { return (ccfg_instr *)_p; }
//     ccfg_instr *operator()() const { return (ccfg_instr *)_p; }
};

class p_ccfg_block : public p_ccfg_node {
public:
    p_ccfg_block(ccfg_block *p = 0) : p_ccfg_node((ccfg_node *)p) {}
    p_ccfg_block(const p_ccfg_block& o) : p_ccfg_node(o) {}
    p_ccfg_block(const p_ccfg_node& o) : p_ccfg_node(o) {}
    ccfg_block *operator->() const { return (ccfg_block *)_p; }
//     ccfg_block *operator()() const { return (ccfg_block *)_p; }
};

class p_ccfg_test : public p_ccfg_node {
public:
    p_ccfg_test(ccfg_test *p = 0) : p_ccfg_node((ccfg_node *)p) {}
    p_ccfg_test(const p_ccfg_test& o) : p_ccfg_node(o) {}
    p_ccfg_test(const p_ccfg_node& o) : p_ccfg_node(o) {}
    ccfg_test *operator->() const { return (ccfg_test *)_p; }
//     ccfg_test *operator()() const { return (ccfg_test *)_p; }
};


/*---------------------------------------------------------------------------
		    Wrappers for variable reference objects
---------------------------------------------------------------------------*/
class p_varref : public pWrapperStd<varref *> {
public:
    p_varref(varref *p = 0) : pWrapperStd<varref *>(p) {}
    p_varref(const p_varref& o) : pWrapperStd<varref *>(o) {}
};

class p_vardef : public p_varref {
public:
    p_vardef(vardef *p = 0) : p_varref((varref *)p) {}
    p_vardef(const p_vardef& o) : p_varref(o) {}
    p_vardef(const p_varref& o) : p_varref(o) {}
    vardef *operator->() const { return (vardef *)_p; }
//     vardef *operator()() const { return (vardef *)_p; }
};

class p_phiterm : public p_vardef {
public:
    p_phiterm(phiterm *p = 0) : p_vardef((vardef *)p) {}
    p_phiterm(const p_phiterm& o) : p_vardef(o) {}
    p_phiterm(const p_vardef& o) : p_vardef(o) {}
    p_phiterm(const p_varref& o) : p_vardef(o) {}
    phiterm *operator->() const { return (phiterm *)_p; }
//     phiterm *operator()() const { return (phiterm *)_p; }
};

class p_varuse : public p_varref {
public:
    p_varuse(varuse *p = 0) : p_varref((varref *)p) {}
    p_varuse(const p_varuse& o) : p_varref(o) {}
    p_varuse(const p_varref& o) : p_varref(o) {}
    varuse *operator->() const { return (varuse *)_p; }
};

class p_syncref : public p_varref {
public:
    p_syncref(syncref *p = 0) : p_varref((varref *)p) {}
    p_syncref(const p_syncref& o) : p_varref(o) {}
    p_syncref(const p_varref& o) : p_varref(o) {}
    syncref *operator->() const { return (syncref *)_p; }
};

class p_undir_syncref : public p_syncref {
public:
    p_undir_syncref(undir_syncref *p = 0) : p_syncref((syncref *)p) {}
    p_undir_syncref(const p_undir_syncref& o) : p_syncref(o) {}
    p_undir_syncref(const p_syncref& o) : p_syncref(o) {}
    p_undir_syncref(const p_varref& o) : p_syncref(o) {}
    undir_syncref *operator->() const { return (undir_syncref *)_p; }
};

class p_mutex_syncref : public p_undir_syncref {
public:
    p_mutex_syncref(mutex_syncref *p = 0) : p_undir_syncref((undir_syncref*)p){}
    p_mutex_syncref(const p_mutex_syncref& o) : p_undir_syncref(o) {}
    p_mutex_syncref(const p_undir_syncref& o) : p_undir_syncref(o) {}
    p_mutex_syncref(const p_syncref& o) : p_undir_syncref(o) {}
    p_mutex_syncref(const p_varref& o) : p_undir_syncref(o) {}
    mutex_syncref *operator->() const { return (mutex_syncref *)_p; }
};

class p_lockref : public p_mutex_syncref {
public:
    p_lockref(lockref *p = 0) : p_mutex_syncref((mutex_syncref*)p){}
    p_lockref(const p_lockref& o) : p_mutex_syncref(o) {}
    p_lockref(const p_mutex_syncref& o) : p_mutex_syncref(o) {}
    p_lockref(const p_syncref& o) : p_mutex_syncref(o) {}
    p_lockref(const p_varref& o) : p_mutex_syncref(o) {}
    p_lockref(const p_undir_syncref& o) : p_mutex_syncref(o) {}
    lockref *operator->() const { return (lockref *)_p; }
};

class p_unlockref : public p_mutex_syncref {
public:
    p_unlockref(unlockref *p = 0) : p_mutex_syncref((mutex_syncref*)p){}
    p_unlockref(const p_unlockref& o) : p_mutex_syncref(o) {}
    p_unlockref(const p_mutex_syncref& o) : p_mutex_syncref(o) {}
    p_unlockref(const p_syncref& o) : p_mutex_syncref(o) {}
    p_unlockref(const p_varref& o) : p_mutex_syncref(o) {}
    p_unlockref(const p_undir_syncref& o) : p_mutex_syncref(o) {}
    unlockref *operator->() const { return (unlockref *)_p; }
};

/*---------------------------------------------------------------------------
			     Container definitions
---------------------------------------------------------------------------*/
/* Use sets when it's important to store the elements in order. */
typedef list<p_ccfg_node> list_ccfg_node;
typedef set<p_ccfg_node> set_ccfg_node;
typedef list<conflict> list_conflict;
typedef set<conflict> set_conflict;
typedef list<p_vardef> vector_vardef;
typedef map<p_tree_node, p_tree_par> map_tree_par;
typedef multiset<p_phiterm> set_phiterm;
typedef multiset<p_vardef> set_vardef;
typedef multiset<p_varref> set_varref;
typedef multiset<p_varuse> set_varuse;
typedef set<p_var_sym> set_var_sym;
typedef vector<p_var_sym> vector_var_sym;
typedef vector<p_sym_node> vector_sym_node;
typedef vector<p_phiterm> vector_phiterm;
typedef vector<p_varuse> vector_varuse;
typedef vector<p_ccfg_node> vector_ccfg_node;
typedef vector<p_var_sym> vector_var_sym;
typedef set<p_mutex_body> mutex_struct;
typedef set<p_lockref> set_lockref;
typedef set<p_unlockref> set_unlockref;

#endif	// __CSSAME_WRAPPERS_H
