#ifndef __D_LEVELINFO_C_H__	/* { */
#define __D_LEVELINFO_C_H__

#pragma set woff 1174

//
// *D_Lib* Copyright 1996-1998  Anatoly Kardash, anatoly-k@usa.net
//
// Permission to use, copy, modify, and distribute, this software
// and its documentation for any purpose is hereby granted without
// fee, provided that the above copyright notice appear in all copies
// and that both that copyright notice and this permission notice
// appear in supporting documentation, and that the name of the
// copyright holders be used in advertising or publicity pertaining
// to distribution of the software with specific, written prior
// permission, and that no fee is charged for further distribution
// of this software, or any modifications thereof. The copyright
// holder make no representations about the suitability of this
// software for any purpose. It is provided "as is" without express
// or implied warranty.
//
// THE COPYRIGHT HOLDER DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR
// ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA, PROFITS, QPA OR GPA,
// WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
// ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//

#include <d_support_c.h>

template <class T>
class D_LevelInfo_c
{
public:
	D_LevelInfo_c( D_Support_c::Scope scope, int weight,
			const int no, T info)
		: _scope( scope),
		  _weight( weight),
		  _no( no),
		  _info( info)
		{}
	D_LevelInfo_c( const D_LevelInfo_c& src)
		: _scope( src._scope),
		  _weight( src._weight),
		  _no( src._no),
		  _info( src._info)
		{}
	D_LevelInfo_c& operator =( const D_LevelInfo_c& src)
		{
			_scope = src._scope;
			_weight = src._weight;
			_no = src._no;
			_info = src._info;
			return( *this);
		}
	~D_LevelInfo_c() {}

	void SetInfo( T info)
		{ _info = info; }

	D_Support_c::Scope	_scope;
	int			_weight;
	int			_no;
	T			_info;

private:
	D_LevelInfo_c() {}
};

//
// special case of the template - working with "char*"
//

class D_LevelInfo_c<char*>
{
public:
	D_LevelInfo_c( D_Support_c::Scope scope, int weight,
			const int no, char* info)
		: _scope( scope),
		  _weight( weight),
		  _no( no)
		{ _info = estrdup( info); }
	D_LevelInfo_c( const D_LevelInfo_c& src)
		: _scope( src._scope),
		  _weight( src._weight),
		  _no( src._no)
		{ _info = estrdup( src._info); }
	D_LevelInfo_c& operator =( const D_LevelInfo_c& src)
		{
			_scope = src._scope;
			_weight = src._weight;
			_no = src._no;
			SetInfo( src._info);
			return( *this);
		}
	~D_LevelInfo_c()
		{ delete[] _info; }

	void SetInfo( char* info)
		{ delete[] _info;
		  _info = estrdup( info);
		}

	D_Support_c::Scope	_scope;
	int			_weight;
	int			_no;
	char			*_info;

private:
	D_LevelInfo_c() {}

	static char* estrdup( const char* src)
	{
		char* dst = new char[ strlen( src) + 1];
		if( dst != 0)
			strcpy( dst, src);
		return( dst);
	}

};

template <class T>
static inline ostream& operator <<( ostream& s, D_LevelInfo_c<T>& o)
{
	s << "D_LevelInfo_c: _no = [" << o._no << "] _info = [" <<
		o._info << "]\n" << flush;
	return( s);
}

#endif	/* } __D_LEVELINFO_C_H__ */
