#ifndef __D_MASKINFO_C_H__	/* { */
#define __D_MASKINFO_C_H__

#pragma set woff 1174

//
// *D_Lib* Copyright 1996-1998  Anatoly Kardash, anatoly-k@usa.net
//
// Permission to use, copy, modify, and distribute, this software
// and its documentation for any purpose is hereby granted without
// fee, provided that the above copyright notice appear in all copies
// and that both that copyright notice and this permission notice
// appear in supporting documentation, and that the name of the
// copyright holders be used in advertising or publicity pertaining
// to distribution of the software with specific, written prior
// permission, and that no fee is charged for further distribution
// of this software, or any modifications thereof. The copyright
// holder make no representations about the suitability of this
// software for any purpose. It is provided "as is" without express
// or implied warranty.
//
// THE COPYRIGHT HOLDER DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR
// ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA, PROFITS, QPA OR GPA,
// WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
// ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//

#include <d_string_c.h>

struct D_level_info_for_find
{
	D_Support_c::Scope	scope;
	int			no;

	D_level_info_for_find( D_Support_c::Scope s, int n)
		: scope( s), no( n)
	{}
};

template <class T>
class D_MaskInfo_c
{
public:
	D_MaskInfo_c( const char* msk, D_Support_c::Scope scope,
			int weight, int lvl_no, T info)
		: _mask( msk),
		  _mask_str( msk)
		{ SetLevelInfo( scope, weight, lvl_no, info); }
	D_MaskInfo_c( const D_MaskInfo_c& mi)
		: _mask( mi._mask),
		  _mask_str( mi._mask_str),
		  _levels( mi._levels)
		{}
	~D_MaskInfo_c() {}

	D_RegExp_c::statVal GetRegExpStatus()
		{ return( _mask.status()); }

	int Compare( const char* str) const		// using regexp
	{
		const D_String_c s( str);
		if( s( _mask) == s)
			return( 1);
		return( 0);
	}

	int CompareMask( const char* str) const		// exactly
	{
		if( strcmp( str, _mask_str) == 0)
			return( 1);
		return( 0);
	}

	void SetLevelInfo( D_Support_c::Scope scope,
			int weight, int lvl_no, T info);

	D_String_c& GetMaskStr()
		{ return( _mask_str); }
	D_List_c< D_LevelInfo_c<T> >& GetLevelInfos()
		{ return( _levels); }

	static int FindLevelInfo(
			const D_LevelInfo_c<T>& linfo, void* data)
	{
		const D_level_info_for_find* li =
			(const D_level_info_for_find*)data;
		if( linfo._no != li->no)
			return( 0);
		if( li->scope == D_Support_c::D_ANY_SCOPE)
			return( 1);
		if( linfo._scope == li->scope)
			return( 1);
		return( 0);
	}

private:
	D_String_c			_mask_str;
	D_RegExp_c			_mask;
	D_List_c< D_LevelInfo_c<T> >	_levels;

	D_MaskInfo_c<T>& operator =( D_MaskInfo_c<T>&)
		{ return( *this); }

friend ostream& operator <<( ostream& s, const D_MaskInfo_c<T>& o);
};

template <class T>
static inline ostream& operator <<( ostream& s,
		const D_MaskInfo_c<T>& o)
{
	s << "D_MaskInfo_c: _mask_str = [" << o._mask_str <<
		"]\n" << flush;
	size_t m_entries = o._levels.entries();
	for( size_t i = 0; i < m_entries; i ++)
	{
		D_MaskInfo_c<T>& o1 = (D_MaskInfo_c<T>&)o;
		D_LevelInfo_c<T>& li = o1._levels.at( i);
		s << "\t" << li;
	}
	return( s);
}

void D_MaskInfo_c<char*>::SetLevelInfo( D_Support_c::Scope scope,
		int weight, int lvl_no, char* info)
{
	D_level_info_for_find tmp( scope, lvl_no);
	size_t index = _levels.index(
			FindLevelInfo, (void*)&tmp);
	if( index == NO_SUCH_ELEMENT)
	{
		_levels.insert( D_LevelInfo_c<char*>(
				scope, weight, lvl_no, info));
		return;
	}
	D_LevelInfo_c<char*>& li = _levels.at( index);
	li.SetInfo( info);
	li._weight = weight;
}

// MS! We have to implement all the cases here not in class def (why?..)
template <class T>
void D_MaskInfo_c<T>::SetLevelInfo( D_Support_c::Scope scope,
		int weight, int lvl_no, T info)
{
	D_level_info_for_find tmp( scope, lvl_no);
	size_t index = _levels.index(
			FindLevelInfo, (void*)&tmp);
	if( index == NO_SUCH_ELEMENT)
	{
		_levels.insert( D_LevelInfo_c<T>(
				scope, weight, lvl_no, info));
		return;
	}
	D_LevelInfo_c<T>& li = _levels.at( index);
	li._info = info;
	li._weight = weight;
}

#endif	/* } __D_MASKINFO_C_H__ */
