/**
$Id: find-doall.cc,v 2.1 1999/02/19 20:06:45 diego Exp $
*/
#include <string.h>
#include <suif_copyright.h>
#include <suif.h>

#include "findpar.h"

/**
Analyze the given tree_node to check if it's a parloop loop.
*/
void 
find_parloop(tree_node *t, void *)
{
    if (t->is_for()) {
	tree_for *tf = (tree_for *)t;
	tree_node *marker = tf->list_e()->prev()->contents;

	if (marker->is_instr()) {
	    instruction *instr = ((tree_instr *)marker)->instr();
	    if (instr->opcode() == io_ldc) {
		operand dst = instr->dst_op();
		if (dst.is_symbol() && 
		    strcmp(dst.symbol()->name(), PARLOOP) == 0) {
			/* Remove the marker from its original location */
			marker->parent()->remove(marker->list_e());

			/* Add parloop annotation to the loop */
			tf->append_annote(k_parloop);
		}
	    }
	}
    }
}
