/**
$Id: main.cc,v 2.3 1999/02/19 20:06:47 diego Exp $

SUIF pass to find lexical parallelism in a C program. Two parallel
constructs are recognized: `parloop' and `cobegin/coend'. To avoid
modifying the front-end we cheat by creating two macros. A `parloop' is a
for loop with index variable __ODC_parloop. A `cobegin/coend' is a switch
statement with index variable __ODC_cobegin (check odyssey.h for macro
definition).
*/
#include <suif_copyright.h>
#include <suif.h>

#include "findpar.h"

char *k_parloop;
char *k_cobegin;

//---------------------------------------------------------------------------
// findPar()
// Traverse every AST in the current procedure looking for a parloop or a
// cobegin.
//---------------------------------------------------------------------------
void 
findPar(tree_proc *tp)
{
    tp->map(find_parloop, NULL);
    tp->map(find_cobegin, NULL);
}


main(int argc, char *argv[])
{
    init_suif(argc, argv);

    ANNOTE(k_parloop, "parloop", TRUE);
    ANNOTE(k_cobegin, "cobegin", TRUE);

    /* Process the program with writeback = TRUE because we will modify the
     * program marking all the parallel constructs.
     */
    suif_proc_iter(argc, argv, findPar, TRUE);

    return 0;
}
