/**
$Id: fixpgen.cc,v 2.2 1998/10/31 21:54:43 diego Exp $

This is a hack to fix incorrect label names generated by `pgen' inside
switch() statements.
*/
#include <stdio.h>
#include <string.h>
#include <suif.h>

FILE *STDOUT;

//---------------------------------------------------------------------------
// fixjump()
// If this is an jump node, we make sure that the labels correspond to the
// labels in the local symbol table. We check each label name, if the local
// symbol table defines the same name, we use it. Otherwise we leave it
// alone.
//---------------------------------------------------------------------------
void
fixjump(tree_node *t, void *ptr)
{
    char *labname;
    label_sym *local;
    tree_instr *ti;

    ptr = ptr;				// To avoid 'never used' warning.

    /* Only deal with tree_instr nodes */
    if (t->is_instr() == FALSE) return;

    ti = (tree_instr *)t;

    /* Check multiway branches */
    if (ti->instr()->opcode() == io_mbr) {
	in_mbr *mbr_i = (in_mbr *)ti->instr();

	/* Fix the labels */
	unsigned i;
	for (i = 0; i < mbr_i->num_labs(); i++) {
	    labname = mbr_i->label(i)->name();
	    local = (label_sym *)ti->scope()->lookup_sym(labname, SYM_LABEL, 0);
	    if (local != NULL) {
		mbr_i->set_label(i, local);
	    }
	}

	/* Fix the default label */
	labname = mbr_i->default_lab()->name();
	local = (label_sym *)ti->scope()->lookup_sym(labname, SYM_LABEL, 0);
	if (local != NULL) {
	    mbr_i->set_default_lab(local);
	}
    }

    /* Check regular jumps */
    if_ops opcode = ti->instr()->opcode();
    if (opcode == io_jmp || opcode == io_btrue || opcode == io_bfalse) {
	in_bj *jump_i = (in_bj *)ti->instr();
	labname = jump_i->target()->name();
	local = (label_sym *)ti->scope()->lookup_sym(labname, SYM_LABEL, FALSE);
	if (local != NULL) {
	    jump_i->set_target(local);
	}
    }
}


void 
do_proc(tree_proc *tp)
{
    tp->map(fixjump, (void *)tp->proc()->name());
}


main(int argc, char *argv[])
{
    init_suif(argc, argv);

    STDOUT = stdout;

    suif_proc_iter(argc, argv, do_proc, TRUE);

    return 0;
}
