/**
$Id: main.cc,v 2.5 1999/02/19 20:06:47 diego Exp $
*/
#include <stdio.h>

#include <suif.h>
#include <par.h>

FILE *STDOUT;

/* These annotations are recognized by SUIF's pgen when generating
 * parallel code for a program.
 */
char *k_begin_parallel_region;
char *k_end_parallel_region;
char *k_doall;

/**
If the given tree_node is a cobegin, mark it with a parallel region markers
as required by 'pgen'. Parallel regions are enclosed by
'begin_parallel_region' and 'end_parallel_region' annotations.
*/
void
replace_cobegin(tree_node *t, void *)
{
    tree_cobegin *cobegin;

    /* Only process cobegin trees */
    if (!::is_cobegin(t)) return;

    cobegin = new tree_cobegin(t);

    tree_instr *entry = (tree_instr *)cobegin->entry().ptr();
    tree_instr *exit = (tree_instr *)cobegin->exit().ptr();

    entry->instr()->append_annote(k_begin_parallel_region);
    exit->instr()->append_annote(k_end_parallel_region);

    p_tree_instr mbr_t = cobegin->entry();
    in_mbr *mbr_i = (in_mbr *)mbr_t->instr();

    var_sym *mbr_var = new var_sym(type_signed, "_my_id");
    t->scope()->add_sym(mbr_var);
    operand mbr_op(mbr_var);
    mbr_i->set_src(mbr_op);
}

/**
Mark parloops with the 'doall' annotation as required by 'pgen'.
*/
void
replace_parloop(tree_node *t, void *)
{
    tree_for *parloop;

    /* Only process parloop trees */
    if (!::is_parloop(t)) return;

    parloop = (tree_for *)t;
    parloop->append_annote(k_doall);
}


void 
do_proc(tree_proc *tp)
{
    tp->map(replace_cobegin, NULL);
    tp->map(replace_parloop, NULL);
}


main(int argc, char *argv[])
{
    LIBRARY(par, init_par, exit_par);
    init_suif(argc, argv);

    ANNOTE(k_begin_parallel_region, "begin_parallel_region", TRUE);
    ANNOTE(k_end_parallel_region, "end_parallel_region", TRUE);
    ANNOTE(k_doall, "doall", TRUE);

    STDOUT = stdout;

    suif_proc_iter(argc, argv, do_proc, TRUE);

    return 0;
}
