/**
$Id: Odyssey.h,v 1.7 1999/02/17 02:08:58 diego Exp $

Odyssey compiler class definition.
*/
#ifndef	__OCC_H
#define	__OCC_H

#include <list>
#include <set>

#include <str.h>
#include <d_lib.h>

#include <CompilerPass.h>

using namespace std;

class Odyssey { D_CLASS(Odyssey)
    /** Private data members */
    int _argc;			/// Number of arguments on the command line.
    char **_argv;		/// Command line argument array.
    String _progname;		/// Name of the compiler binary (argv[0]).
    String _stop_at;		/// Stop compiling at this extension.
    bool _compile_only;		/// Do not generate binary, just object files.
    String _defines;		/// C preprocessor symbol definitions.
    bool _debug;		/// Flag to generate debugging information.
    bool _help;			/// Flag to display help message.
    String _incdirs;		/// Include directories.
    bool _keep_inter;		/// Flag to keep intermediate files.
    String _libdirs;		/// Library directories.
    String _libs;		/// Libraries to link.
    bool _modify_output_name;	/// Append optimizations done to output name.
    String _output_name_suffix;	/// Suffix to append to the output name.
    String _output_name;	/// Name for the generated executable.
    String _optlevel;		/// Optimization level.
    unsigned _verbose;		/// Flag to produce verbose output.
    bool _version;		/// Flag to display version information.
    list<SourceFile> _files;	/// Source files to process.
    set<String> _tmpFiles;	/// Temporary files to remove at the end.
    String _dfa_list;		/// String with DFA passes to run.
    String _opt_list;		/// String with OPT passes to run.
    list<dfa *> _dfaPasses;	/// List of analysis passes to run.
    list<opt *> _optPasses;	/// List of optimization passes to run.

    /* Environment variables needed by the compiler */
    String _ODYSSEY;
    String _SUIFHOME;
    String _MACHINE;

    /** Private methods */
    void parseCmdLine();
    String getenv(const char *varname);
    void initSUIF();
    void exitSUIF();
    void parse();
    void transform();
    void gencode();
    void buildSUIFfileset();
    void buildListOfDFAPasses();
    void buildListOfOPTPasses();


    /** Public methods */
    public:
    Odyssey(int argc, char **argv);
    ~Odyssey();

    /* Access methods */
    const String& progname() const { return _progname; }
    const String& stop_at() const { return _stop_at; }
    bool compile_only() const { return _compile_only; }
    const String& defines() const { return _defines; }
    const String& incdirs() const { return _incdirs; }
    bool keep_inter() const { return _keep_inter; }
    const String& libdirs() const { return _libdirs; }
    const String& libs() const { return _libs; }
    bool modify_output_name() const { return _modify_output_name; }
    const String& output_name_suffix() const { return _output_name_suffix; }
    const String& output_name() const { return _output_name; }
    const String& optlevel() const { return _optlevel; }
    unsigned verbose() const { return _verbose; }
    const set<String>& tmpFiles() const { return _tmpFiles; }
    const String& dfaList() const { return _dfa_list; }
    const String& optList() const { return _opt_list; }
    list<dfa *>& dfaPasses() { return _dfaPasses; }
    list<opt *>& optPasses() { return _optPasses; }

    /* Misc methods */
    int run();
    bool link();
    void addTmpFile(const String& name) { _tmpFiles.insert(name); }

    void showHelp();
    void showVersion();
    ostream& print(ostream &os) const;
};

/* Free functions */
ostream& operator<<(ostream& os, const Odyssey &compiler);

/* Global variables */
extern Odyssey *OCC;

#endif	// __OCC_H
