/**
$Id: SourceFile.h,v 1.3 1999/01/12 23:53:51 diego Exp $
*/
#ifndef __SOURCE_FILE_H
#define __SOURCE_FILE_H

#include <iostream.h>

#include <str.h>

class cssamePass;
class ccfgPass;
class FileState;
class ccfg;
class cssame;
class file_set;

class SourceFile {
    String _name;	/// Name of the file as given on the command line.
    String _dirname;	/// Directory name.
    String _basename;	/// Name of the file without directory nor extension.
    String _ext;	/// Original extension (determines initial state).
    FileState *_state;	/// Current file state (determines what passes to run).

    void copyFrom(const SourceFile& orig);

    public:
    SourceFile(char *name);

    /** Make the source file a concrete type so that we can pass them
     * around. We must use this to keep lists of files (list<SourceFile>).
     */
    SourceFile(const SourceFile& orig) { this->copyFrom(orig); }
    SourceFile& operator=(const SourceFile& orig) { 
	this->copyFrom(orig);
	return *this;
    }
    ~SourceFile();

    /** Access methods */
    const String& origname() const { return _name; }
    const String& origext() const { return _ext; }
    const String& dirname() const { return _dirname; }
    const String& basename() const { return _basename; }
    FileState *state() const { return _state; }

    /** Allow modifications of the basename. Used by the compiler if the
     * user wants each output file name to reflect the internal
     * optimization passes done by the compiler. For instance, if the -n
     * switch is specified on the command line and the list of optimization
     * mbl,licm,dce is requested, the new basename will be
     * 'file-mbl-licm-dce'.
     */
    void modify_basename();


    /** SourceFile::name() returns the canonical file name that reflects
     * the conversions that the file has been through (ie, the extension of
     * the name returned is likely different from the original extension).
     * The same updated information is returned by SourceFile::ext(). To
     * get the original name and extension use SourceFile::origname() and
     * SourceFile::origext().
     */
    const String name() const { return _dirname + "/" + _basename + ext(); }
    const String& ext() const;

    /** Predicate to determine whether this file has been fully processed */
    bool done() const;

    /** State transition method. Every time this method is called, a state
     * transition occurs. This state transition will be an external SUIF
     * pass or an internal transformation. See filestate.h for details.
     */
    void transform();

    ostream& print(ostream& os) const;
};

/* Free functions */
ostream& operator<<(ostream& os, const SourceFile &file);

#endif	// __SOURCE_FILE_H
