/**
Odyssey compiler driver. This is the main entry point to the Odyssey
compiler. All the CSSAME analysis and optimization methods are called from
here.

This program will parse/analyze/optimize a collection of .c files and
generate an executable.
*/
#include <iostream.h>

#include "compiler.h"

Odyssey *OCC;

main(int argc, char **argv)
{
    int ec;

    cout.setf(ios::unitbuf);	/* Flush cout after every insertion */
    cout.setf(ios::stdio);	/* Flush stdout after every insertion */

    cerr.setf(ios::unitbuf);	/* Flush cerr after every insertion */
    cerr.setf(ios::stdio);	/* Flush stderr after every insertion */

    ios::sync_with_stdio();	/* Synchronize cout with stdout */

    try {
	OCC = NULL;
	OCC = new Odyssey(argc, argv);
	ec = OCC->run();
	delete OCC;
    }

    catch(Error& e) {
	e.show();
	e.action();
    }

    return ec;
}
