/**
$Id: CompilerPass.cc,v 2.12 1999/03/05 14:50:44 diego Exp $
*/
#include <suif_copyright.h>

#include "CompilerPass.h"


static p_cssame buildCSSAMEFor(p_tree_proc tp);


/**
Base run method for optimization passes. This generic method works for most
passes. It builds the CSSAME form for the procedure and executes the
optimization pass.

It should be overloaded if the pass that you're creating needs to do
anything else.
*/
void
opt::setup(p_tree_proc tp)
{
    _tp  = tp;
    _ssa = buildCSSAMEFor(_tp);
}


/**
Remove the CSSAME form and renumber the instructions in the procedure.
*/
void
opt::cleanup()
{
    /* Renumber all the instructions again. Some optimizations generate new
     * code that might not have been numbered yet. This is not strictly
     * necessary, but makes debugging easier.
     */
    _tp->number_instrs();

    /* [HACK]. This should be handled by the pointer wrappers. */
    delete _ssa.ptr();
}


/**
Build the CSSAME form for the procedure and display it on cout.
*/
bool
cssamePass::run(p_tree_proc tp)
{
    p_cssame ssa = buildCSSAMEFor(tp);
    if (_verbose > 0) {
	ssa->print();
    }

    /* [HACK]. This should be handled by the pointer wrappers. */
    delete ssa.ptr();

    return true;	/* [HACK]. Should this method return false? */
}



/*---------------------------------------------------------------------------
			 Internal helper functions
---------------------------------------------------------------------------*/
/**
Helper function to build the CSSAME form for the given procedure.
*/
p_cssame
buildCSSAMEFor(p_tree_proc tp)
{
    p_ccfg graph = ::get_ccfg(tp);
    assert(graph);
    return new cssame(graph);
}


/*---------------------------------------------------------------------------
		    Methods for statistic collection classes
---------------------------------------------------------------------------*/
/**
Base print method for stat objects that collect information about locks and
critical sections in the program.
*/
void
MutexStat::print(ostream& s) const
{
    if (!_active) {
	return;
    }

    s << "Mutex synchronization statistics for '" << 
	_pass.proc()->proc()->name() << "'\n\n";

    s << "Number of lock variables: " << _pass.ssa()->mutexVars().size()
	<< endl;

    set_var_sym::iterator iter = _pass.ssa()->mutexVars().begin();
    for (; iter != _pass.ssa()->mutexVars().end(); iter++) {
	p_var_sym var = *iter;
	mutex_struct *mxstruct = get_mutex_struct(var);

	cout << "Number of mutex bodies for '" << var->name() << "': "
	    << mxstruct->size() << endl;
    }
}
