/**
$Id: call_query.h,v 1.1 1999/02/18 18:23:18 diego Exp $
*/
#ifndef __CALL_QUERY_H
#define __CALL_QUERY_H

#include <suif_copyright.h>
#include <suif.h>

enum call_order {
    NO_CALLS,
    CALLS_TOTALLY_ORDERED,
    CALLS_NOT_TOTALLY_ORDERED
};

/*----------------------------------------------------------------------*
    in file "call_query.cc":
 *----------------------------------------------------------------------*/

/*
 *  This function is used to tell whether or not the impure function
 *  call instructions and io_gen instructions in an expression tree
 *  form a perfect ordering in terms of the instruction tree.  The
 *  reason we want to know this is that if they do form a perfect
 *  order, we are guaranteed that the children of the lowest level
 *  call instruction will be evaluated before any calls are made.
 *  Otherwise, we cannot know that any particular instructions in the
 *  entire tree will be executed before all calls; there will always
 *  be legal orders of evaluation that evaluate some call before any
 *  given instruction.
 */
extern call_order call_query(instruction *the_instr);

#endif
