/**
$Id: cse.h,v 1.2 1999/03/05 14:50:44 diego Exp $
*/
#ifndef __CSE_H
#define __CSE_H

#include "CompilerPass.h"

/**
Common Subexpression Elimination (CSE)
*/
class cse : public opt { D_CLASS(cse)
public:
    cse(bool showStats, unsigned verbose = 0);
    virtual const char *id() const { return "cse"; }
    virtual void printStats(ostream& s = cout) const { _stat.print(s); }

    class stats : public OptStat {
    public:
	stats(const cse& pass, bool active = false) : OptStat(pass, active) {}
	virtual const char *id() const { return "cse::stats"; }
    };


protected:
    virtual bool execute();
    void proc_cse(tree_proc *the_proc);

    cse::stats _stat;
};
#endif
