/**
$Id: gcp.h,v 2.5 1999/03/05 14:50:46 diego Exp $
*/
#ifndef __GCP_H
#define __GCP_H

#include "CompilerPass.h"

/**
Global Constant Propagation (GCP).
*/
class gcp : public opt { D_CLASS(gcp)
public:
    gcp(bool showStats, unsigned verbose = 0);
    virtual const char *id() const { return "gcp"; }
    virtual void printStats(ostream& s = cout) const;

    class stats : public OptStat {
    public:
	stats(const gcp& pass, bool active = false)
	    : OptStat(pass, active), _num_folded(0) {}

	void add_constant_replacement_for(p_var_sym var);
	void add_folded_expr(unsigned lineno);
	unsigned num_folded() const { return _num_folded; }
	virtual void print(ostream &s = cout) const;
	virtual const char *id() const { return "gcp::stats"; }

    protected:
	map<p_var_sym, unsigned> _constant_vars;
	set<unsigned> _folded_exprs;
	unsigned _num_folded;
    };


protected:
    virtual bool execute();

    void propagate_constants(p_tree_node the_node);
    void fold_all_constants(p_tree_proc the_proc);

    bool _made_progress;

    gcp::stats _stat;
};
#endif
