/**
$Id: licm.h,v 2.7 1999/03/05 14:50:46 diego Exp $
*/
#ifndef __LICM_H
#define __LICM_H

#include "CompilerPass.h"

/**
Lock Independent Code Motion (LICM).
*/
class licm : public opt { D_CLASS(licm)
public:
    licm(bool showStats, unsigned verbose = 0);
    virtual const char *id() const { return "licm"; }
    virtual void printStats(ostream& s = cout) const { _stat.print(s); }

protected:
    /**
    Statistics collector for LICM objects
    */
    class licmStat : public MutexStat {
    public:
	licmStat(const licm& pass, bool active = false)
	    : MutexStat(pass, active) {}

	virtual void print(ostream& s = cout) const;
	virtual const char *id() const { return "licmStat"; }

	void addHoistedStmt(const p_mutex_body& mb);
	void addEmptyMB(const p_mutex_body& mb);
	void addNonMovableStmt(const p_mutex_body& mb);
	void addMovableStmt(const p_mutex_body& mb);
	void addLIStmt(const p_mutex_body& mb);
	void addRLIStmt(const p_mutex_body& mb);

    protected:
	typedef map<p_mutex_body, unsigned> licm_counter;

	licm_counter _hoisted_stmts;
	licm_counter _empty_mbs;
	licm_counter _non_movable_stmts;
	licm_counter _movable_stmts;
	licm_counter _LI_stmts;
	licm_counter _RLI_stmts;

	void incr(licm_counter& counter, const p_mutex_body& mb);
	void print_counter(const licm_counter& counter, const p_var_sym& var, 
		ostream& s) const;
    };


    enum Direction { UP, DOWN };

    char *k_to_premutex;
    char *k_to_postmutex;
    char *k_move;

    licmStat _stat;

    static const int NOT_MOVABLE = 0x0;
    static const int PREMUTEX	 = 0x2;
    static const int POSTMUTEX	 = 0x4;

    bool _made_progress;

    void doLICM(p_mutex_body mb);
    void tryToMove(p_tree_node stmt, p_mutex_body mb);
    int isMovable(p_tree_node stmt, p_mutex_body mb, p_tree_node enclCtrl);
    int isCtrlStructMovable(p_tree_node stmt, p_mutex_body mb, 
	    p_tree_node enclCtrl);
    bool hasDependencies(p_tree_instr instr, p_mutex_body mb, p_tree_node
	    enclCtrl, Direction dir);
    bool hasDependencies(p_tree_instr i1, p_tree_instr i2);
    bool hasDependencies(p_tree_instr ti, p_tree_node tn);
    bool isLI(p_tree_instr stmt);
    virtual bool isRelaxedLI(p_varref ref) { ref = ref; return false; }
    void moveStmt(p_tree_node stmt, p_mutex_body mb);

    virtual bool execute();

};


/**
Relaxed Lock Independent Code Motion (RLICM).
*/
class rlicm : public licm { D_CLASS(rlicm)
public:
    rlicm(bool showStats, unsigned verbose = 0) : licm(showStats, verbose) {}
    virtual const char *id() const { return "rlicm"; }
    virtual void printStats(ostream& s = cout) const { _stat.print(s); }

protected:
    virtual bool isRelaxedLI(p_varref ref);
    unsigned numConflictingDefs(p_var_sym var);
};
#endif
