/**
$Id: mbl.h,v 2.8 1999/03/05 14:50:47 diego Exp $
*/
#ifndef __MBL_H
#define __MBL_H

#include "CompilerPass.h"

class mblStat;

/**
Mutex Body Localization (MBL)
*/
class mbl : public opt { D_CLASS(mbl)
public:
    /** Reasons for not localizing a variable */
    enum reasons {
	OK_TO_LOCALIZE,		// Variable can be localized.
	NO_REFERENCES,		// There are no references to it in the pgm.
	NO_CONFLICTS, 		// There are no conflicting refs to it.
	SPILLED, 		// The variable is an array or struct or its
				//	address has been taken or it's a global.
	ITS_SYNC_VAR,		// The variable is a synchronization object.
	CONFLICTS_OUTSIDE_MB	// There are conflicts outside this mutex body.
    };

    /**
    Localization tuples describe reasons why a variable could or could not be
    localized in a particular mutex structure.
    */
    struct locTuple {
	String _key;
	p_var_sym _lock;
	p_var_sym _var;
	mbl::reasons _reason;

	locTuple(p_var_sym lock, p_var_sym var, 
		mbl::reasons reason = mbl::OK_TO_LOCALIZE) : _lock(lock), 
		_var(var), _reason(reason), _key(lock->name()) {
	    _key += _var->name();
	}

	bool operator<(const locTuple& o2) const { return (_key < o2._key); }
	bool operator==(const locTuple& o2) const { return (_key == o2._key); }

	friend ostream& operator<<(ostream& s, const locTuple& o);
    };


    mbl(bool showStats, unsigned verbose = 0);
    virtual const char *id() const { return "mbl"; }
    virtual void printStats(ostream& s = cout) const;

protected:
    /**
    Statistics collector for MBL objects (Mutex Body Localization).
    */
    class mblStat : public MutexStat {
	friend class mbl;

    public:
	mblStat(const mbl& pass, bool active = false) 
	    : MutexStat(pass, active) {}

	virtual void print(ostream& s = cout) const;
	virtual const char *id() const { return "mblStat"; }

    protected:
	set<locTuple> _localizedVars;
	set<locTuple> _nonLocalizedVars;
	map<locTuple, unsigned> _entryCopies;
	map<locTuple, unsigned> _exitCopies;
	map<locTuple, unsigned> _localizedRefs;

	/* Methods to update collected data */
	void addLocalizableVar(p_var_sym var, p_mutex_body mb);
	void addNonLocalizableVar(p_var_sym var, p_mutex_body mb, 
		mbl::reasons reason);
	void addEntryCopyFor(p_var_sym var, p_mutex_body mb);
	void addLocalizedReference(p_var_sym var, p_mutex_body mb);
	void addSharedReference(p_var_sym var);
	void addExitCopyFor(p_var_sym var, p_mutex_body mb);
	map<p_var_sym, unsigned> countSharedReferences() const;
    };


    mbl::mblStat _stat;

    bool _made_progress;

    void localize(p_var_sym var, p_mutex_body mb);
    void createEntryCopy(p_var_sym var, block& local, p_mutex_body mb);
    void modifyInteriorRefs(p_var_sym var, block& local, p_mutex_body mb);
    void replaceRefWith(instruction *instr, p_var_sym var, block& local);
    void createExitCopy(p_var_sym var, block& local, p_mutex_body mb);
    void doMBL(p_mutex_body mb);
    set_var_sym findVarsToLocalize(p_mutex_body mb);
    bool isLocalizable(p_var_sym var, p_mutex_body mb);
    bool hasConflicts(p_var_sym var);
    bool hasConflictsOutsideMS(p_var_sym var, p_mutex_body mb);

    virtual bool execute();
};

#endif
