/**
$Id: propagate.h,v 1.2 1999/03/05 14:50:48 diego Exp $
*/
#ifndef __PROPAGATE_H
#define __PROPAGATE_H

#include "CompilerPass.h"

enum forward_prop_kind { FPK_ALL, FPK_SIMPLE_LOCAL_VARS };

extern boolean instr_might_store(instruction *the_instr, var_sym *the_var);
void forward_propagate(tree_node *the_node, forward_prop_kind which_kind);

/**
Copy propagation
*/
class copy_prop : public opt { D_CLASS(copy_prop)
public:
    copy_prop(bool showStats, unsigned verbose = 0);
    virtual const char *id() const { return "copy_prop"; }
    virtual void printStats(ostream& s = cout) const { _stat.print(s); }

    class stats : public OptStat {
    public:
	stats(const copy_prop& pass, bool active = false)
	    : OptStat(pass, active) {}
	virtual const char *id() const { return "copy_prop::stats"; }
    };

protected:
    virtual bool execute();

    copy_prop::stats _stat;
};

/**
Forward propagation
*/
class forward_prop : public copy_prop { D_CLASS(forward_prop)
public:
    forward_prop(bool showStats, unsigned verbose = 0)
	: copy_prop(showStats, verbose) {}

    virtual const char *id() const { return "forward_prop"; }

protected:
    virtual bool execute();
};
#endif
