/* file "reuse.cc" */

/*  Copyright (c) 1995 Stanford University

    All rights reserved.

    This software is provided under the terms described in
    the "suif_copyright.h" include file. */

#include <suif_copyright.h>

/* code to determine which expressions to try to reuse instead of
 * re-computing dynamically (when doing common-subexpression
 * elimination and loop-invariant moving) for the porky program for
 * SUIF */


#define RCS_BASE_FILE reuse_cc

#include "reuse.h"

RCS_BASE(
    "$Id: reuse.cc,v 1.5 1999/03/05 14:50:48 diego Exp $")

boolean merge_globals;

/*----------------------------------------------------------------------*
    Begin Constant Declarations
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
    End Constant Declarations
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
    Begin Type Declarations
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
    End Type Declarations
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
    Begin Private Global Variables
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
    End Private Global Variables
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
    Begin Private Function Declarations
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
    End Private Function Declarations
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
    Begin Public Function Implementations
 *----------------------------------------------------------------------*/

extern 
bool reuse_desired(operand the_op)
{
    if (the_op.is_expr())
      {
        if (the_op.instr()->opcode() == io_ldc)
            return FALSE;
        return TRUE;
      }
    if (the_op.is_symbol())
        return (merge_globals && the_op.symbol()->is_global());
    return FALSE;
}


/** Local helper for reuse_possible() */
static bool has_conflicting_rdefs(instruction *in);

/**
If the given instruction has conflicting references, it cannot be 'reused'.
*/
extern bool
reuse_possible(instruction *in)
{
    D_STACK(reuse_possible);
    D_SELFTEST_HEADER(590, "reuse_possible");

    D_SELFTEST(590) {
	cout << "*** Testing if it's possible to reuse instruction\n";
	in->print(stdout, 8); fflush(stdout);
	cout << "*** Uses for the instruction:\n";
	set_varuse *uses = get_varuses(in);
	copy(uses->begin(), uses->end(), 
		ostream_iterator<p_varuse>(cout, "\n"));
	cout << endl;
    }

    if (has_conflicting_rdefs(in)) {
	D_SELFTEST(590) { cout << "*** No, it makes conflicting references.\n"; }
	D_SELFTEST_FOOTER(590);
	return false;
    }

    for (unsigned i = 0; i < in->num_srcs(); i++) {
	operand op = in->src_op(i);

	D_SELFTEST(590) { cout << "\n*** Checking operator #" << i << "\n"; }

	if (op.is_instr()) {
	    D_SELFTEST(591) {
		cout << "*** Uses for the operator:\n";
		set_varuse *uses = get_varuses(op.instr());
		copy(uses->begin(), uses->end(), 
			ostream_iterator<p_varuse>(cout, "\n"));
		cout << endl;
	    }

	    if (has_conflicting_rdefs(op.instr())) {
		D_SELFTEST(590) { cout << "*** It has conflicts.\n"; }
		D_SELFTEST_FOOTER(590);
		return false;
	    }
	}
    }

    D_SELFTEST(590) { cout << "*** Yes, it has no conflicts.\n"; }
    D_SELFTEST_FOOTER(590);
    return true;
}

static bool
has_conflicting_rdefs(instruction *in)
{
    set_varuse *uses = get_varuses(in);
    for (set_varuse::iterator i = uses->begin(); i != uses->end(); i++) {
	p_varuse use = *i;
	vector_thread_body *use_threads;
	use_threads = ::get_thread_bodies(use->instr()->parent());
	if (!use_threads) {
	    continue;	/* Skip if the use is in a sequential section */
	}

	vector_vardef rdefs = use->reachingDefs();
	for (vector_vardef::iterator i = rdefs.begin(); i != rdefs.end(); i++) {
	    p_vardef rdef = *i;
	    vector_thread_body *rdef_threads;
	    rdef_threads = ::get_thread_bodies(rdef->instr()->parent());
	    if (!rdef_threads) {
		continue;	/* Skip if the reaching def comes from a
				   sequential section. */
	    }

	    if (::have_concurrent_threads(use_threads, rdef_threads)) {
		return true;
	    }
	}
    }

    return false;
}





/*----------------------------------------------------------------------*
    End Public Function Implementations
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
    Begin Private Function Implementations
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*
    End Private Function Implementations
 *----------------------------------------------------------------------*/
