/**
$Id: wrappers-optlib.h,v 2.1 1999/02/09 18:03:48 diego Exp $

Wrappers for pointer classes in the OptLib module
*/
#ifndef __WRAPPERS_OPTLIB_H
#define __WRAPPERS_OPTLIB_H


/**
Base wrapper class
*/
class p_CompilerPass : public pWrapper<CompilerPass *> {
public:
    p_CompilerPass(CompilerPass *p = 0) : pWrapper<CompilerPass *>(p) {}
    p_CompilerPass(const p_CompilerPass& o) : pWrapper<CompilerPass *>(o) {}
};


/*---------------------------------------------------------------------------
			    Wrappers for DFA classes
---------------------------------------------------------------------------*/
class p_dfa : public p_CompilerPass {
public:
    p_dfa(dfa *p = 0) : p_CompilerPass(p) {}
    p_dfa(const p_dfa& o) : p_CompilerPass(o) {}
};

class p_cssamePass : public p_dfa {
public:
    p_cssamePass(cssamePass *p = 0) : p_dfa(p) {}
    p_cssamePass(const p_cssamePass& o) : p_dfa(o) {}
};


/*---------------------------------------------------------------------------
			    Wrappers for OPT classes
---------------------------------------------------------------------------*/
class p_opt : public p_CompilerPass {
public:
    p_opt(dfa *p = 0) : p_CompilerPass(p) {}
    p_opt(const p_opt& o) : p_CompilerPass(o) {}
};

class p_dce : public p_opt {
public:
    p_dce(dfa *p = 0) : p_opt(p) {}
    p_dce(const p_dce& o) : p_opt(o) {}
};

class p_gcp : public p_opt {
public:
    p_gcp(dfa *p = 0) : p_opt(p) {}
    p_gcp(const p_gcp& o) : p_opt(o) {}
};

class p_licm : public p_opt {
public:
    p_licm(dfa *p = 0) : p_opt(p) {}
    p_licm(const p_licm& o) : p_opt(o) {}
};

class p_rlicm : public p_licm {
public:
    p_rlicm(dfa *p = 0) : p_licm(p) {}
    p_rlicm(const p_licm& o) : p_licm(o) {}
};

class p_mbl : public p_opt {
public:
    p_mbl(dfa *p = 0) : p_opt(p) {}
    p_mbl(const p_mbl& o) : p_opt(o) {}
};


/*---------------------------------------------------------------------------
			 Wrappers for statistic classes
---------------------------------------------------------------------------*/
class p_OptStat : public pWrapper<OptStat *> {
public:
    p_OptStat(OptStat *p = 0) : pWrapper<OptStat *>(p) {}
    p_OptStat(const p_OptStat& o) : pWrapper<OptStat *>(o) {}
};


class p_MutexStat : public p_OptStat {
public:
    p_MutexStat(MutexStat *p = 0) : p_OptStat(p) {}
    p_MutexStat(const p_MutexStat& o) : p_OptStat(o) {}
};

class p_mblStat : public p_MutexStat {
public:
    p_mblStat(mblStat *p = 0) : p_MutexStat(p) {}
    p_mblStat(const p_mblStat& o) : p_MutexStat(o) {}
};

#endif	// __WRAPPERS_OPTLIB_H
