/**
$Id: odc-threads.cc,v 2.4 1999/03/13 19:12:54 diego Exp $
*/
#include "par.h"

/**
Thread body destructor. Remove all the annotations added by the
tree_cobegin constructor.
*/
thread_body::~thread_body()
{
}

/**
Returns the set of parallel tree ancestors for this thread (ie, all the
parallel structures enclosing it).
*/
const vector_tree_par&
thread_body::panc() const
{
    return _parent->panc();
}

/**
Displays the thread body on the given stream.
*/
void
thread_body::print(ostream& s, int depth) const
{
    thread_node_iter iter((thread_body *)this);

    while (!iter.is_empty()) {
	iter.step()->print(stdout, depth);
    }
    s.flush();
    fflush(stdout);
}


/**
Returns true if this thread body can execute concurrently with the given
thread body.

NOTE: Nested cobegin/coend structures should be handled by this but it has
      not been tested. Be careful. (4-Feb-99)
*/
bool
thread_body::is_concurrent_with(p_thread_body t2) const
{
    D_SELFTEST_HEADER(690, "thread_body::is_concurrent_with");

    /* Trivial case */
    if (!t2) {
	return false;
    }


    /* If they are the same body, they are concurrent only if one of the
     * body's ancestors is a parloop structure.
     */
    if (this == t2.ptr()) {
	vector_tree_par::const_iterator i;
	for (i = this->panc().begin(); i != this->panc().end(); i++) {
	    if ((*i)->is_tree_parloop()) {
		return true;
	    }
	}

	return false;
    }


    /* They are not the same thread body. Check the common ancestors. If they
     * have at least one common parallel ancestor, the threads are concurrent.
     */

    D_SELFTEST(690) {
	cout << "Parallel ancestors for thread #" << _number << endl;
	vector_tree_par::const_iterator i;
	for (i = this->panc().begin(); i != this->panc().end(); i++) {
	    (*i)->entry()->print(); cout << endl;
	}
	cout << endl;

	cout << "Parallel ancestors for thread #" << t2->number() << endl;
	for (i = t2->panc().begin(); i != t2->panc().end(); i++) {
	    (*i)->entry()->print(); cout << endl;
	}
	cout << endl;
    }

    set<p_tree_par> result;
    set_intersection(this->panc().begin(), this->panc().end(),
		     t2->panc().begin(), t2->panc().end(),
		     inserter(result, result.begin()));

    D_SELFTEST(690) {
	cout << "They are" << ((result.empty()) ? " not" : "") 
	    << " concurrent.\n";
    }

    D_SELFTEST_FOOTER(690);

    return (!result.empty());
}


/*----------------------------------------------------------------------------
		       Methods for class thread_node_iter
---------------------------------------------------------------------------*/
thread_node_iter::thread_node_iter(const p_thread_body t, bool reverse)
{
    _first = t->first()->list_e();
    _last = t->last()->list_e();
    _sentinel = reverse ? _first : _last; 
    _rev = reverse; 
    this->reset(); 
}


/**
Reset the iter to the beginning of the basic block.
*/
void
thread_node_iter::reset()
{
    _cur = NULL;
    _nxt = _rev ? _last : _first;
}


/**
Step the iter to the next instruction.
*/
p_tree_node
thread_node_iter::step()
{
    /* Return NULL if at end of thread */
    if (_cur == _sentinel) {
	return NULL;
    }

    _cur = _nxt;
    _nxt = _rev ? _nxt->prev() : _nxt->next();
    return p_tree_node(_cur->contents);
}


/**
Look at the next instruction, but don't step the iter.
*/
p_tree_node
thread_node_iter::peek()
{
    /* Return NULL if at end of basic block */
    if (_cur == _sentinel) {
	return NULL;
    }

    return p_tree_node(_nxt->contents);
}


/**
Am I at the end of the instructions in this thread?
*/
bool
thread_node_iter::is_empty()
{
    return (_cur == _sentinel);
}

