/**
$Id: odc-threads.h,v 2.2 1999/03/02 18:38:44 diego Exp $
*/
#ifndef __ODC_THREADS_H
#define __ODC_THREADS_H

/*---------------------------------------------------------------------------
				 Thread classes
---------------------------------------------------------------------------*/
/**
Base thread body class.
*/
class thread_body { D_CLASS(thread_body)
public:
    thread_body(p_tree_par par, unsigned num, p_tree_node t1, p_tree_node t2)
	: _parent(par), _number(num), _first(t1), _last(t2) {}
    thread_body() : _parent(0), _number(0), _first(0), _last(0) {}
    virtual ~thread_body();

    /* Inspectors */
    p_tree_par parent() const { return _parent; }
    unsigned number() const { return _number; }
    p_tree_node first() const { return _first; }
    p_tree_node last() const { return _last; }

    void print(ostream& s = cout, int depth = 0) const;

    /* Overridable behaviour */
    virtual const char *id() const = 0;
    virtual bool is_cobegin_thread() const { return false; }
    virtual bool is_parloop_thread() const { return false; }

    /* Concurrency information */
    bool is_concurrent_with(p_thread_body t2) const;
    const vector_tree_par& panc() const;

    void extend(p_tree_node t2) { _last = t2; }

protected:
    p_tree_par _parent;
    unsigned _number;
    p_tree_node _first;
    p_tree_node _last;
};


/**
Thread body class for cobegin/coend structures.
*/
class cobegin_thread : public thread_body { D_CLASS(cobegin_thread)
public:
    cobegin_thread(p_tree_cobegin par, unsigned num, p_tree_node t1, 
	    p_tree_node t2) : thread_body(par, num, t1, t2) {}
    cobegin_thread() : thread_body() {}
    virtual ~cobegin_thread() {}

    virtual const char *id() const { return "cobegin_thread"; }
    virtual bool is_cobegin_thread() const { return true; }
};


/**
Thread body class for parloop structures.
*/
class parloop_thread : public thread_body { D_CLASS(parloop_thread)
public:
    parloop_thread(p_tree_parloop par, p_tree_node t1, p_tree_node t2)
	: thread_body(par, 0, t1, t2) {}
    parloop_thread() : thread_body() {}
    virtual ~parloop_thread() {}

    virtual const char *id() const { return "parloop_thread"; }
    virtual bool is_parloop_thread() const { return true; }
};



/**
Instruction iterator for thread bodies.
*/
class thread_node_iter {
public:
    thread_node_iter(const p_thread_body t, bool reverse=false);

    void reset();
    void set(tree_node_list_e *nxt) { _nxt = nxt; }
    p_tree_node step();
    p_tree_node peek();

    bool is_empty();

private:
    tree_node_list_e *_first;
    tree_node_list_e *_last;
    tree_node_list_e *_sentinel;
    tree_node_list_e *_cur;
    tree_node_list_e *_nxt;
    bool _rev; 
};
#endif
