/**
$Id: odc-trees.h,v 2.2 1999/03/02 18:38:45 diego Exp $
*/
#ifndef __ODC_TREES_H
#define __ODC_TREES_H

/*---------------------------------------------------------------------------
			      Parallel constructs
---------------------------------------------------------------------------*/
/**
Base class for parallel constructs.
*/
class tree_par {
public:
    tree_par(p_tree_node tn);
    virtual ~tree_par();

    virtual p_tree_node entry() const { return _tn; }
    virtual p_tree_node exit() const = 0;
    unsigned num_threads() const { return _threads.size(); }
    p_thread_body thread(unsigned num) const { return _threads[num]; }

    virtual bool is_tree_cobegin() const { return false; }
    virtual bool is_tree_parloop() const { return false; }

    void print(ostream& s = cout, int depth = 0) const;

    const vector_tree_par& panc() const { return _panc; }

    typedef pair<const p_tree_par, const p_thread_body> ann_pair;

protected:
    p_tree_node _tn;			/// Tree node
    vector_tree_par _panc;		/// Parallel ancestors (nested 
					///	structures).
    vector_thread_body _threads;	/// List of thread bodies.

    void annotate_threads() const;

private:
    void add_annotation(p_tree_node tn, tree_par::ann_pair *ann) const;
    void remove_annotation(p_tree_node tn) const;
};



/**
cobegin/coend parallel structure.
*/
class tree_cobegin : public tree_par { D_CLASS(tree_cobegin)
public:
    tree_cobegin(p_tree_node mbr);
    virtual ~tree_cobegin() {}
    virtual p_tree_node exit() const { return _last; }
    p_label_sym deflab() const { return _instr->default_lab(); }
    virtual bool is_tree_cobegin() const { return true; }

private:
    p_tree_instr _last;			/// Last instruction
    in_mbr *_instr;			/// mbr representing the cobegin/coend
    set<p_label_sym> _labels;		/// Start-of-thread markers

    bool isEndOfThread(instruction *instr);
};



/**
parloop parallel structure.
*/
class tree_parloop : public tree_par { D_CLASS(tree_parloop)
public:
    tree_parloop(p_tree_node tn);
    virtual ~tree_parloop() {}

    virtual p_tree_node exit() const { return _tf->body()->tail()->contents; }
    virtual bool is_tree_parloop() const { return true; }
    p_tree_for loop() const { return _tf; }
    p_var_sym index() const { return _tf->index(); }

private:
    p_tree_for _tf;
};
#endif
