/**
$Id: par.h,v 2.7 1999/03/05 14:50:49 diego Exp $

Top-level Parallel Library Include File for Odyssey 
*/
#ifndef __PAR_H
#define __PAR_H

#include <vector>
#include <set>
#include <algo.h>
#include <iostream.h>

#include <suif_copyright.h>
#include <suif.h>

#include <d_lib.h>
#include <wrappers.h>

using namespace std;


/*---------------------------------------------------------------------------
	Annotations used to mark cobegin/coend and parloop instructions
---------------------------------------------------------------------------*/
extern char *k_cobegin;		/* Instruction is the start of a cobegin 
				   structure. */

extern char *k_parloop;		/* Instruction is the start of a parloop
				   structure. */

extern char *k_par_parents;	/* Pointer to set of parallel parents. A
				   parallel parent is an instruction that
				   starts the parallel structure holding
				   this instruction. */

extern char *k_thread_bodies;	/* Pointer to set of thread bodies holding
				   this instruction. */

/*---------------------------------------------------------------------------
		     Pointer wrappers for the tree classes
---------------------------------------------------------------------------*/
class tree_par;
class tree_cobegin;
class tree_parloop;

typedef pWrapper<tree_par *> p_tree_par;

class p_tree_cobegin : public p_tree_par {
public:
    p_tree_cobegin(tree_cobegin *p = 0) : p_tree_par((tree_par *)p) {}
    p_tree_cobegin(const p_tree_cobegin& o) : p_tree_par(o) {}
    p_tree_cobegin(const p_tree_par& o) : p_tree_par(o) {}
    tree_cobegin *operator->() const { return (tree_cobegin *)_p; }
};

class p_tree_parloop : public p_tree_par {
public:
    p_tree_parloop(tree_parloop *p = 0) : p_tree_par((tree_par *)p) {}
    p_tree_parloop(const p_tree_parloop& o) : p_tree_par(o) {}
    p_tree_parloop(const p_tree_par& o) : p_tree_par(o) {}
    tree_parloop *operator->() const { return (tree_parloop *)_p; }
};


/*---------------------------------------------------------------------------
		    Pointer wrappers for the thread classes
---------------------------------------------------------------------------*/
class thread_body;
class cobegin_thread;
class parloop_thread;

typedef pWrapper<thread_body *> p_thread_body;

class p_cobegin_thread : public p_thread_body {
public:
    p_cobegin_thread(cobegin_thread *p = 0) : p_thread_body((thread_body *)p) {}
    p_cobegin_thread(const p_cobegin_thread& o) : p_thread_body(o) {}
    p_cobegin_thread(const p_thread_body& o) : p_thread_body(o) {}
    cobegin_thread *operator->() const { return (cobegin_thread *)_p; }
};

class p_parloop_thread : public p_thread_body {
public:
    p_parloop_thread(parloop_thread *p = 0) : p_thread_body((thread_body *)p) {}
    p_parloop_thread(const p_parloop_thread& o) : p_thread_body(o) {}
    p_parloop_thread(const p_thread_body& o) : p_thread_body(o) {}
    parloop_thread *operator->() const { return (parloop_thread *)_p; }
};

/*---------------------------------------------------------------------------
				  Collections
---------------------------------------------------------------------------*/
typedef vector<p_thread_body>	vector_thread_body;
typedef vector<p_tree_par>	vector_tree_par;


/* Use a macro to include files so that they can be treated differently
 * when compiling the library than when compiling an application.
 */
#ifdef PARLIB
#	include "odc-threads.h"
#	include "odc-trees.h"
#else
#	include <odc-threads.h>
#	include <odc-trees.h>
#endif

/*---------------------------------------------------------------------------
			       Free functions
---------------------------------------------------------------------------*/
void init_par(int & /* argc */, char * /* argv */ []);
void exit_par();

bool is_par(p_tree_node tn);
bool is_cobegin(p_tree_node tn);
bool is_cobegin(instruction *instr);
bool is_parloop(p_tree_node tn);

vector_tree_par *get_tree_par_parents(suif_object *obj);
vector_thread_body *get_thread_bodies(suif_object *obj);

p_proc_sym func_symbol(instruction *call);

bool have_concurrent_threads(vector_thread_body *tv1, vector_thread_body *tv2);

#endif /* __PAR_H */
