/**
$Id: odc-util.cc,v 2.7 1999/01/27 18:39:23 diego Exp $
*/
#include <suif_copyright.h>

#include <stdio.h>
#include <stdlib.h>
#include <str.h>

#include "odc-util.h"

static char _lastline[MAX_LINE_SIZE + 1];

//---------------------------------------------------------------------------
// displayFile()
// Outputs a range of lines of a file to stdout. Returns the last line
// read as a pointer to a static array of characters.
//---------------------------------------------------------------------------
char *
displayFile(char *fname, int start, int end, unsigned flags, ostream& to)
{
    String str(file2String(fname, start, end, flags));

    to << str;

    return _lastline;
}


//---------------------------------------------------------------------------
// file2String()
// Reads a file into a string and returns it. It also sets the local
// variable _lastline to the last line read from the file.
//---------------------------------------------------------------------------
String
file2String(char *fname, int start, int end, unsigned flags)
{
    static char line[MAX_LINE_SIZE + 1];
    int lineno = 1;
    FILE *f;
    String str;
    String str_line;
    
    f = fopen(fname, "r");
    if (f == NULL) {
	perror(fname);
	exit(-1);
    }

    /* Skip the first 'start' lines */
    while (lineno < start) {
	fgets(line, MAX_LINE_SIZE, f);
	lineno++;
    }

    /* Read lines between 'start' and 'end'. */
    while (lineno <= end && !feof(f)) {
	fgets(line, MAX_LINE_SIZE, f);
	str_line = line;

	if (!feof(f)) {
	    if (flags & DF_LINENO) {
		char str_lineno[8];
		sprintf(str_lineno, "%7d ", lineno);
		str_line.Insert(0, str_lineno);
	    }

	    if (flags & DF_QUOTES) {
		str_line.Replace("\"", "'");
	    }

	    if (flags & DF_LTRIM) {
		str_line.Trim(String::LEFT);
	    }

	    if (flags & DF_RTRIM) {
		str_line.Trim(String::RIGHT);
	    }

	    if (flags & DF_TRIMLAST && lineno == end) {
		str_line.Replace("\n", "");
	    }

	    if (flags & DF_XLATE) {
		str_line.Replace("\n", "\\n");
	    }

	    str += str_line;
	    lineno++;
	}
    }

    fclose(f);

    if (str_line()) {
	strcpy(_lastline, str_line());
    } else {
	_lastline[0] = '\0';
    }

    return str;
}

int
debug(char *fname, int level)
{
    return 0;
}
