/**
$Id: odc-util.h,v 2.5 1998/12/08 18:10:41 diego Exp $
*/
#include <suif_copyright.h>

#ifndef __ODC_UTIL_H
#define __ODC_UTIL_H

#include <str.h>

#define MAX_LINE_SIZE	1024

/* Flags to modify the behaviour of routine displayFile() */
const unsigned DF_NONE	   = 0x00;
const unsigned DF_LINENO   = 0x01; /* Displays line numbers */
const unsigned DF_QUOTES   = 0x02; /* Translates double quotes to single */
const unsigned DF_LTRIM	   = 0x04; /* Trims leading space characters */
const unsigned DF_RTRIM	   = 0x08; /* Trims trailing space characters */
const unsigned DF_XLATE	   = 0x10; /* Translates ctrl characters */
const unsigned DF_TRIMLAST = 0x20; /* Trims last newline character */

char *displayFile(char *fname, int start, int end, unsigned flags = DF_NONE, 
	ostream& to = cout);
String file2String(char *fname, int start, int end, unsigned flags = DF_NONE);
int debug(char *fname, int level);

#endif /* __ODC_UTIL_H */
